<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class File extends Model 
{

    protected $table = 'files';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('project_id', 'status', 'file_url', 'file_name', 'file_type');

    public function project()
    {
        return $this->belongsTo('App\Models\Project');
    }

}